/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.inbaskets;

import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.toolkit.design.canvas.IVWDesignerCanvasPanel;
import filenet.vw.toolkit.design.canvas.inbaskets.VWDesignerWorkBasketPanel;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class VWInbasketCanvasPanel
extends JPanel
implements IVWDesignerCanvasPanel {
    private VWDesignerCoreData m_designerCoreData = null;
    private VWDesignerWorkBasketPanel m_workBasketsPanel = null;

    public VWInbasketCanvasPanel(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
        this.createControls();
    }

    public void notifyListeners() {
        if (this.m_workBasketsPanel != null) {
            this.m_workBasketsPanel.notifyListeners();
        }
        try {
            if (this.m_workBasketsPanel != null) {
                this.m_workBasketsPanel.checkForErrors();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_error, 0);
        }
    }

    public void initializeActionMenu(JMenu actionMenu) {
        if (actionMenu != null) {
            actionMenu.removeAll();
        }
    }

    public void initializeEditMenu(JMenu editMenu) {
        if (editMenu != null) {
            editMenu.removeAll();
        }
    }

    public void releaseReferences() {
        this.m_designerCoreData = null;
        if (this.m_workBasketsPanel != null) {
            this.m_workBasketsPanel.releaseResources();
            this.m_workBasketsPanel = null;
        }
    }

    private void createControls() {
        this.setLayout(new BorderLayout(6, 6));
        this.m_workBasketsPanel = new VWDesignerWorkBasketPanel(this.m_designerCoreData);
        this.add((Component)this.m_workBasketsPanel, "Center");
    }
}

